define([
    'backbone',
    'Layout',
    'modules/new-appointment-request/views/direct/pac-team/section-view',
], function(Backbone, Layout, ProvidersSectionView) {
    'use strict';

    describe('Providers Section', function() {
        var view;
        var $view;
        var layout;
        var model = new Backbone.Model({
            primaryProviderList: 'V. A., M. D., D. C.',
            facilityId: '345',
            facilityName: 'TEST VAMC',
        });
        model.getFacilityName = function() {
            return this.get('facilityName');
        };
        model.getInstitutionCode = function() {
            return '123AB';
        };

        layout = new Layout();

        layout.render();

        beforeEach(function() {
            spyOn(ProvidersSectionView.prototype, 'viewPactTeamModal');

            view = new ProvidersSectionView({
                model: model,
                team: new Backbone.Collection([
                    {
                        possiblePrimary: '',
                        staffName: 'One',
                    },
                    {
                        possiblePrimary: '',
                        staffName: 'Two',
                    },
                ]),
            });

            layout.showChildView('content', view);
            $view = view.$el;
        });

        it('shows the Primary Provider List for the current facility', function() {
            expect($view.find('.static-label').text()).toEqual('Providers:');
            expect($view.find('.pact-team-link > span').first()
                .text()).toEqual('Your Care Team (PACT)');
        });

        it('has a link to view the Care Team (PACT)', function() {
            expect($view.find('.pact-team-link').length).toBe(1);
            expect($view.find('.pact-team-link [aria-hidden="true"]').text()).toEqual('Your Care Team (PACT)');
            expect($view.find('.pact-team-link .ui-hidden-accessible').text()).toEqual('Your Care Team (PACT) for TEST VAMC');
        });

        it('calls viewPactTeamModal on click of the link', function() {
            $view.find('.pact-team-link').click();
            expect(view.viewPactTeamModal).toHaveBeenCalled();
        });
    });
}
);
